#-*- coding: utf-8 -*-
from ctypes import *
import os
import sys
public_path = os.path.normpath(os.path.dirname(os.path.abspath(__file__)) + "/../public")
sys.path.append(public_path)
from librockmong import *
from device import *
from gpio import *
from time import sleep

if __name__ == '__main__':
    SerialNumbers = (c_int * 20)()
    sn = 0
    # Scan device
    ret = Device_Scan(byref(SerialNumbers))
    if (0 > ret):
        print("Error: %d"%ret)
        if ret == -1003:
            print("请参考常见问题文件夹下面处理一下权限问题！")
        exit()
    elif(ret == 0):
        print("No device!")
        exit()
    else:
        for i in range(ret):
            print("Dev%d SN: %d"%(i, SerialNumbers[i]))
    
    sn = SerialNumbers[0]#选择设备0
    
    # 打开设备
    ret = Device_Open(sn)
    if (0 > ret):
        print("error: %d"%ret)
        exit()

    #控制OUT0继电器吸合（晶体管断开）
    ret = IO_WritePin(sn, 0, 1)
    if (0 > ret):
        print("error: %d"%ret)
        exit()
    
    #读取输出状态
    PinState = (c_int)()
    ret = IO_ReadOutputPin(sn, 0, byref(PinState))
    if (0 > ret):
        print("error: %d"%ret)
        exit()
    print("Pin state: %d"%PinState.value)
    
    #控制OUT0继电器断开（晶体管导通）
    ret = IO_WritePin(sn, 0, 0)
    if (0 > ret):
        print("error: %d"%ret)
    
    #读取输出状态
    ret = IO_ReadOutputPin(sn, 0, byref(PinState))
    if (0 > ret):
        print("error: %d"%ret)
        exit()
    print("Pin state: %d"%PinState.value)
        
    #读取IN0输入状态
    PinState = (c_int)()
    ret = IO_ReadPin(sn, 0, byref(PinState))
    if (0 > ret):
        print("error: %d"%ret)
        exit()
    print("Pin state: %d"%PinState.value)

    # 关闭设备
    ret = Device_Close(sn)


    
