package com.rockmong.demo_io;

import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.rockmong.rockmong.MISC;
import com.rockmong.rockmong.IO;
import com.rockmong.rockmong.UsbDevice;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class IOActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int ret;
        int[] SerialNumbers = new int[16];
        ret = UsbDevice.INSTANTCE.UsbDevice_Scan(SerialNumbers);
        if (0 > ret) {
            System.out.println("Error: " + ret);
            return;
        }
        else if (0 == ret){
            System.out.println("No Device!");
            return;
        }
        else{
            for (int i = 0; i < ret; i++){
                System.out.println("Dev" + i + " SN: " + SerialNumbers[i]);
            }
        }

        //控制所有输出端0~7继电器断开（晶体管导通）
        ret = IO.INSTANCE.IO_WritePin_Bit(sn, 0xFFFF);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        //控制所有输出端0~7继电器吸合（晶体管断开）
        ret = IO.INSTANCE.IO_WritePin_Bit(sn, 0x0000);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }

        //读取所有输入端状态
        IntByReference PinState = new IntByReference();
        ret = IO.INSTANCE.IO_ReadPin_Bit(sn, PinState);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        int state = PinState.getValue();
        System.out.printf("PinState (Hex): 0x%08X%n", state);
    }

}
