﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Rockmong;

namespace Demo_IO
{
    class Program
    {
        static void Main(string[] args)
        {
            int ret = 0, i;
            int[] SerialNumbers = new int[16];
            int PinState = 0;
            int SerialNumber;

            ret = Device.Device_Scan(SerialNumbers);
            if (ret < 0)
            {
	            Console.Write("Scan error: %d\n", ret);
                return;
            }
            else if (ret == 0)
            {
	            Console.Write("No device\n");
                return;
            }
            else
            {
	            for (i = 0; i < ret; i++)
	            {
		            Console.WriteLine("Dev" + i.ToString() + " SN: " + SerialNumbers[i].ToString());
	            }
            }

            SerialNumber = SerialNumbers[0];

            ret = Device.Device_Open(SerialNumber);
            if (ret < 0)
            {
                Console.Write("Open error: %d\n", ret);
                return;
            }

            //控制OUT0继电器断开（晶体管导通）
            ret = io.IO_WritePin(SerialNumber, 0, 0);
            if (ret < 0)
            {
                Console.WriteLine("Error: " + ret.ToString());
            }

            //控制OUT0继电器吸合（晶体管断开）
            ret = io.IO_WritePin(SerialNumber, 0, 1);
            if (ret < 0)
            {
                Console.WriteLine("Error: " + ret.ToString());
            }

            //读取IN0状态
            ret = io.IO_ReadPin(SerialNumber, 0, ref PinState);
            if (ret < 0)
            {
                Console.WriteLine("Error: " + ret.ToString());
            }
            Console.WriteLine("Read pin: " + PinState.ToString());

            ret = Device.Device_Close(SerialNumber);
            if (ret < 0)
            {
                Console.Write("Close error: %d\n", ret);
                return;
            }
        }
    }
}
