#-*- coding: utf-8 -*-
from ctypes import *
import os
import sys
public_path = os.path.normpath(os.path.dirname(os.path.abspath(__file__)) + "/../public")
sys.path.append(public_path)
from librockmong import *
from device import *
from counter import *
from time import sleep

if __name__ == '__main__':
    SerialNumbers = (c_int * 20)()
    sn = 0
    # Scan device
    ret = Device_Scan(byref(SerialNumbers))
    if (0 > ret):
        print("Error: %d"%ret)
        if ret == -1003:
            print("请参考常见问题文件夹下面处理一下权限问题！")
        exit()
    elif(ret == 0):
        print("No device!")
        exit()
    else:
        for i in range(ret):
            print("Dev%d SN: %d"%(i, SerialNumbers[i]))
    
    sn = SerialNumbers[0]#选择设备0

    # 打开设备
    ret = Device_Open(sn)
    if (0 > ret):
        print("error: %d"%ret)
        exit()

    # 计数器通道0
    channel = 0

    # 计数器初始化。下降沿，加计数
    ret = Counter_Init(sn, channel, 1, 1, 0)
    if (0 > ret):
        print("error: %d"%ret)
        exit()
        
    # 计数器数值清零
    ret = Counter_Write(sn, channel, 0)
    if (0 > ret):
        print("error: %d"%ret)
        exit()
        
    # 计数器开始运行
    ret = Counter_Start(sn, channel)
    if (0 > ret):
        print("error: %d"%ret)
        exit()

    print("Counter channel %d start ..."%channel)
    while True:
        counter_value = (c_int)()
        # 读取计数器数值
        ret = Counter_Read(sn, channel, byref(counter_value))
        if (0 > ret):
            print("error: %d"%ret)
            break
        print("Counter value: %d"%counter_value.value)
        sleep(1)

    print("Counter stop")
    # 计数器停止运行
    ret = Counter_Stop(sn, channel)
    if (0 > ret):
        print("error: %d"%ret)
        exit()

    # 关闭设备
    ret = Device_Close(sn)
    



    
