import com.rockmong.rockmong.Device;
import com.rockmong.rockmong.IO;
import com.sun.jna.ptr.IntByReference;

public class demo_io {
    /** 
     * Launch the application. 
     */  
    public static void main(String[] args) {
    	int ret;
        int[] SerialNumbers = new int[16];
        ret = Device.INSTANCE.Device_Scan(SerialNumbers);
        if (0 > ret) {
            System.out.println("Error: " + ret);
            if (ret == -1003){
                System.out.println("请参考常见问题文件夹里面处理一下权限问题");
            }
            return;
        }
        else if (0 == ret){
            System.out.println("No Device!");
            return;
        }
        else{
            for (int i = 0; i < ret; i++){
                System.out.println("Dev" + i + " SN: " + SerialNumbers[i]);
            }
        }

        int sn = SerialNumbers[0];

        ret = Device.INSTANCE.Device_Open(sn);
        if (0 > ret) {
            System.out.println("Error: " + ret);
            return;
        }

        //控制Y0继电器吸合（晶体管断开）
        ret = IO.INSTANCE.IO_WritePin(sn, 0, 1);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        //控制Y0继电器断开（晶体管导通）
        ret = IO.INSTANCE.IO_WritePin(sn, 0, 0);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }

        //读取X0输入状态
        IntByReference PinState = new IntByReference();
        ret = IO.INSTANCE.IO_ReadPin(sn, 0, PinState);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
        System.out.println("PinState: " + PinState.getValue());

        ret = Device.INSTANCE.Device_Close(sn);
        if (0 > ret) {
            System.out.println("Error: " + ret);
        }
    }
}
